﻿<%
'Memcached客户端基本操作测试

Dim Fasp
Set Fasp = Server.CreateObject("Fasp.FastASP")

' （原本是像个API文档的，每个方法、参数及使用都详细描述了，但是丢了。重新补充就简单弄到一起说明一下。）

' 所有方法的参数的命名规则说明：
' key 键名，要求长度大于0小于250的非空白字符串
' key() 多个键名的数组
' value 键值
' keyIsChecked 键名合法性是否已检查，为False表示未检查，那么函数内部将进行检查
' expiry 过期时间
' unique 签名锁

Dim tim1, tim2'计时器
tim1 =Fasp.Tim.SmoothGet()

Call Fasp.WN("------1------")

' 1、连接服务端方法 Connect
' 连接成功后返回True，否则False
' 该方法主要有4个重载
' Fasp.MC.Connect()'缺省host和port，默认127.0.0.1:11211
' Fasp.MC.Connect("127.0.0.1")'缺省port，默认11211
' Fasp.MC.Connect(Array("192.168.1.2:11211, "192.168.1.3:11211"))'多个服务端

Call Fasp.WN(Fasp.MC.Connect("127.0.0.1", 11211))'指定单个服务端IP、端口

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------2------")

' 2、获取、设置客户端缓存区长度 SendBuffer 和 RecvBuffer
' 设置该属性不会影响数据的完整性
' 但是设置恰当的值将明显提高执行效率
' 不宜频繁修改该值，将产生时间开销

Fasp.MC.SendBuffer = 1024 * 1024'设置发送缓冲区，默认值是8192
Fasp.MC.RecvBuffer = 1024 * 1024'设置接受缓冲区，默认值是8192

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------3------")

' 3、获取、设置key前缀 KeyPrefix
' 该属性不会影响SetV、GetV、GetsV等所有方法的key
' 该方法会影响到服务端的实际key，但是Fasp.MC在获取这些item时已经处理了前缀，所以用户不需要在处理了
' 该方法的一个应用场景就是模拟Session，用于区分不同用户的缓存内容
' Fasp.MC.KeyPrefix = CStr(SessionId)

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------4------")

' 4、获取、设置缺省过期时间 Expiry
' 该属性可以设置为Int或Data，默认是0(最长服务端时间)

Fasp.MC.Expiry = 300
Call Fasp.WN(Fasp.MC.Expiry)

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------5------")

' 5、判断与服务端是否仍然连接 Connected

Call Fasp.WN(Fasp.MC.Connected())

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------6------")

' 6、设置所有 key/value 过期 FlushAll
' 该方法开销很大，慎用
' 如非必要可以使用DelK方法使单个key/value过期
' Public Function FlushAll() As Boolean'立即过期
' Public Function FlushAll(ByVal expiry As Long) As Boolean'在 expiry 后过期

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------7------")

' 7、Default属性 Item
' 使用默认参数获取、设置单个值
Dim Fasp_MC
Set Fasp_MC = Fasp.MC
Fasp_MC.Item("test_key_1") = "test_value_1"'设置key/value
Call Fasp.WN(Fasp_MC.Item("test_key_1"))'读取value

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------8------")

' 8、设置值 SetV
' 成功返回Ture，否则False
' 该方法有4个重载
' Public Function SetV(ByVal key As String, ByVal value As Variant) As Boolean
' Public Function SetV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean) As Boolean
' Public Function SetV(ByVal key As String, ByVal value As Variant, ByVal expiry As Variant) As Boolean
' Public Function SetV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.SetV("test_key_2", Array("test_value_2_1", "test_value_2_2", "test_value_2_3")))'保存数组，检查key的合法性，使用默认过期时间
Call Fasp.WN(Fasp.MC.SetV("test_key_3", Now(), True))'保存时间，第三参数True表示该key不需要进行合法检查，提高执行效率，使用默认过期时间设置
Call Fasp.WN(Fasp.MC.SetV("test_key_4", 1234, 30))'保存整数，检查key的合法性，第三参数表示过期时间设置30
Call Fasp.WN(Fasp.MC.SetV("test_key_5", True, True, 60))'保存布尔值，第三参数True表示key不需要进行合法检查，第四参数True表示过期时间设置60
Call Fasp.WN(Fasp.MC.SetV("test_key_6", Request, True, 60))'保存Fasp.Cons支持的JSONObject

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------9------")

' 9、获取值 GetV 和 GetO
' 有2个方法GetV和GetO，两个方法的参数及其意义完全一样，都有4个重载
' 第一个参数是key或key()，第二个参数表示是否检查key的合法性，False表示需要检查key
' GetO可以获取值类型、数组和对象类型(也就是可以使用Set obj = Fasp.MC.GetO()和value = Fasp.MC.GetO()两种方式)
' GetV只能获取值类型和数组(也就是使用value = Fasp.MC.GetV()这一种方式)，该方法的意义在于执行效率高那么一丢丢
' 以GetV为例，原形如下：
' (1)获取单个值，第一个参数是表示key的字符串
' Public Function GetV(ByVal key As String) As Variant
' Public Function GetV(ByVal key As String, ByVal keyIsChecked As Boolean) As Variant
' (2)获取多个值，第一个参数是表示多个key的字符串数组
' Public Function GetV(ByVal key() As String) As Variant
' Public Function GetV(ByVal key() As String, ByVal keyIsChecked As Boolean) As Variant

Dim Fasp_ARR
Fasp_ARR = Fasp.MC.GetV("test_key_2")'获取数组
Call Fasp.WN(TypeName(Fasp_ARR) & ":" & Fasp_ARR(0) & ":" & Fasp_ARR(1) & ":" & Fasp_ARR(2))'输出数组变量的类型名及数组元素的值
Call Fasp.WN(Fasp.Cons.ToJSON(Fasp_ARR))'使用Fasp.Cons序列化这个数组
Dim Fasp_DIC
Set Fasp_DIC = Fasp.MC.GetV(Array("test_key_3", "test_key_4", "test_key_no_exists"))'获取多个值，test_key_no_exists是不存在的key
Call Fasp.WN(TypeName(Fasp_DIC("test_key_3")) & ":" & Fasp_DIC("test_key_3"))'输出时间类型的类型名及值
Call Fasp.WN(TypeName(Fasp_DIC("test_key_4")) & ":" & Fasp_DIC("test_key_4"))'输出数值类型的类型名及值
Call Fasp.WN(TypeName(Fasp_DIC("test_key_no_exists")) & ":" & Fasp_DIC("test_key_no_exists"))'输出空的类型名及值
Call Fasp.WN(TypeName(Fasp.MC.GetV("test_key_5")) & ":" & Fasp.MC.GetV("test_key_5"))'输出布尔值类型的类型名及值
Call Fasp.WN(Fasp.Cons.ToJSON(Fasp.MC.GetO("test_key_6", True)))'不判断key的合法性，Fasp.MC.GetV去回来JSONObject，然后Fasp.Cons进行序列化

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------10------")

' 10、添加值 AddV
' AddV和SetV类似，它们的区别是：只有当key不存在时，AddV才会保存该key/value
' AddV和SetV方法一样，有四个重载，参数意义和SetV方法也相同
' Public Function AddV(ByVal key As String, ByVal value As Variant) As Boolean
' Public Function AddV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean) As Boolean
' Public Function AddV(ByVal key As String, ByVal value As Variant, ByVal expiry As Variant) As Boolean
' Public Function AddV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.DelK("test_key_7"))'删除test_key_7这个key
Call Fasp.WN(Fasp.MC.AddV("test_key_5", "test_value_5"))'test_key_6这个key已经存在，所以不能完成添加
Call Fasp.WN(Fasp.MC.AddV("test_key_7", "test_value_7"))'test_key_7这个key不存在，所以完成添加

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------11------")

' 11、修改值 RepV
' RepV和SetV类似，它们的区别是：只有当key存在时，RepV才会用新的value替换掉原有的value
' RepV和SetV方法一样，有四个重载，参数意义和SetV方法也相同
' Public Function RepV(ByVal key As String, ByVal value As Variant) As Boolean
' Public Function RepV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean) As Boolean
' Public Function RepV(ByVal key As String, ByVal value As Variant, ByVal expiry As Variant) As Boolean
' Public Function RepV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.RepV("test_key_7", "test_value_replace"))'test_key_7这个key存在，所以完成修改
Call Fasp.WN(Fasp.MC.RepV("test_key_8", "test_value_8"))'test_key_8这个key不存在，所以不会添加

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------12------")

' 12、获取值和签名锁 GetsV 和 GetsO
' 有2个方法GetsV和GetsO，都有4个重载
' GetsV和GetsO的关系 与 GetV和GetO的关系一样
' GetsV方法比GetV方法多一个参数签名锁unique，该参数为传址参数，将返回key/value的签名锁
' 签名锁unique的意义是每次更新key/value对时，该key/value对的签名锁都将自动增加1，读取key/value不改变签名锁
' (1)获取单个值，第一个参数是表示key的字符串，参数unique返回该key/value的签名锁
' Public Function GetsV(ByVal key As String, ByRef unique As Long) As Variant
' Public Function GetsV(ByVal key As String, ByRef unique As Long, ByVal keyIsChecked As Boolean) As Variant
' (2)获取多个值，第一个参数是表示多个key的字符串数组，参数unique返回一个字典，该字典的数据描述是{key1:unique1,key2:unique2......}
' Public Function GetsV(ByVal key() As String, ByRef unique As Variant) As Variant
' Public Function GetsV(ByVal key() As String, ByRef unique As Variant, ByVal keyIsChecked As Boolean) As Variant

Dim Fasp_Unique_7, Fasp_Unique_dic
Call Fasp.WN(Fasp.MC.GetsV("test_key_7", Fasp_Unique_7))'读取值，并传递签名锁
Call Fasp.WN(Fasp_Unique_7)'输出签名锁的值
Call Fasp.WN(Fasp.Cons.ToJSON(Fasp.MC.GetsV(Array("test_key_3", "test_key_4", "test_key_5", "test_key_no_exists"), Fasp_Unique_dic)))'读取多个值，并传递签名锁
Call Fasp.WN(Fasp.Cons.ToJSON(Fasp_Unique_dic))'输出多个签名锁的值

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------13------")

' 13、锁定更新 CasV
' CasV是 Check And Set Value 的缩写
' CasV方法将通过对比签名锁确认目标key/value未被被更新，并设置新的value
' 该方法的返回值定义如下
' Public Enum CasResult
	' Stored = 0'已保存
	' NotStored = 1'未保存
	' Exists = 2'在最后一次取值后另外一个用户也在更新该数据
	' NotFound = 3'不存在该键值
	' Errors = 4'保存出错或语法错误
' End Enum
' CasV和SetV方法大概类似，但是多一个参数 签名锁 unique (该签名锁亦是GetsV方法获取的unique)，其它同名参数的意义和SetV相同
' Public Function CasV(ByVal key As String, ByVal value As Variant, ByVal unique As Long) As Boolean
' Public Function CasV(ByVal key As String, ByVal value As Variant, ByVal unique As Long, ByVal keyIsChecked As Boolean) As Boolean
' Public Function CasV(ByVal key As String, ByVal value As Variant, ByVal unique As Long, ByVal expiry As Variant) As Boolean
' Public Function CasV(ByVal key As String, ByVal value As Variant, ByVal unique As Long, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.CasV("test_key_7", "test_key_7_update_1", Fasp_Unique_7))'因为该key/value未被更新过，签名锁unique未改变，锁定更新成功
Call Fasp.WN(Fasp.MC.CasV("test_key_7", "test_key_7_update_2", Fasp_Unique_7))'因为该key/value已经更新过，签名锁unique改变，锁定更新失败
Call Fasp.WN(Fasp.MC.GetsV("test_key_7", Fasp_Unique_7))'读取值，并传递新的签名锁
Call Fasp.WN(Fasp_Unique_7)'输出新的签名锁的值

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------14------")

' 14、前置添加 PreV
' PreV和RepV类似，它们的区别是：PreV方法是将新的value添加到原value的前面，而不是替换原value
' PreV和RepV方法一样，有四个重载，参数意义和SetV方法也相同
' Public Function PreV(ByVal key As String, ByVal value As Variant) As Boolean
' Public Function PreV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean) As Boolean
' Public Function PreV(ByVal key As String, ByVal value As Variant, ByVal expiry As Variant) As Boolean
' Public Function PreV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.PreV("test_key_7", "pre_7_"))'添加值
Call Fasp.WN(Fasp.MC.GetV("test_key_7"))'输出添加后的值

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------15------")

' 15、后置追加 AppV
' AppV和PreV类似，它们的区别是：AppV方法是将新的value添加到原value的后面
' AppV和PreV方法一样，有四个重载，参数意义和PreV方法也相同
' Public Function AppV(ByVal key As String, ByVal value As Variant) As Boolean
' Public Function AppV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean) As Boolean
' Public Function AppV(ByVal key As String, ByVal value As Variant, ByVal expiry As Variant) As Boolean
' Public Function AppV(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.AppV("test_key_7", "_app_7"))'追加值
Call Fasp.WN(Fasp.MC.GetV("test_key_7"))'输出追加后的值

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------16------")

' 16、设置数值 SetN
' SetN和SetV类似，它们的区别是：SetN将会检查value的类型，要求value必须是Long才能设置成功
' SetN存在的意义是为了数值的自增、自减方法
' SetN和SetV方法一样，有四个重载，参数意义和SetV方法也相同
' Public Function SetN(ByVal key As String, ByVal value As Variant) As Boolean
' Public Function SetN(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean) As Boolean
' Public Function SetN(ByVal key As String, ByVal value As Variant, ByVal expiry As Variant) As Boolean
' Public Function SetN(ByVal key As String, ByVal value As Variant, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.SetN("test_key_8", 100))'设置数值

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------17------")

' 17、获取数值 GetN
' GetN和GetV类似，它们的区别是：GetN将会检查value的类型，如果不是数值，将返回Empty
' 原形如下：
' (1)获取单个值，第一个参数是表示key的字符串
' Public Function GetN(ByVal key As String) As Long
' Public Function GetN(ByVal key As String, ByVal keyIsChecked As Boolean) As Long
' (2)获取多个值，第一个参数是表示多个key的字符串数组
' Public Function GetN(ByVal key() As String) As Variant
' Public Function GetN(ByVal key() As String, ByVal keyIsChecked As Boolean) As Variant

Call Fasp.WN(Fasp.MC.GetN("test_key_8"))'输出数值

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------18------")

' 18、数值自增 Incr
' Incr方法设置数值型的value增加指定的数量，如果key存在返回新值，否值返回Empty
' 原形如下：
' Public Function Incr(ByVal key As String, ByVal value As Long) As Long
' Public Function Incr(ByVal key As String, ByVal value As Long, ByVal keyIsChecked As Boolean) As Long

Call Fasp.WN(Fasp.MC.Incr("test_key_8", 10))'增加10

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------19------")

' 19、数值自减 Decr
' Decr方法设置数值型的value自减指定的数量，如果key存在返回新值，否值返回Empty
' 原形如下：
' Public Function Decr(ByVal key As String, ByVal value As Long) As Long
' Public Function Decr(ByVal key As String, ByVal value As Long, ByVal keyIsChecked As Boolean) As Long

Call Fasp.WN(Fasp.MC.Decr("test_key_8", 5))'减少5

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------20------")

' 20、删除键 DelK
' DelK方法删除指定的key/value对，有4个重载
' 参数expiry表示延时删除的时间(秒)
' Public Function DelK(ByVal key As String) As Boolean
' Public Function DelK(ByVal key As String, ByVal keyIsChecked As Boolean) As Boolean
' Public Function DelK(ByVal key As String, ByVal expiry As Variant) As Boolean
' Public Function DelK(ByVal key As String, ByVal keyIsChecked As Boolean, ByVal expiry As Variant) As Boolean

Call Fasp.WN(Fasp.MC.DelK("test_key_1"))'立即删除test_key_1

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------98------")

' 99、关闭与服务端的连接 Disconnect

Call Fasp.WN(Fasp.MC.Disconnect())

tim2 = Fasp.Tim.SmoothGet()
Call Fasp.WN("计时器：" & (tim2 - tim1))'输出vb计时器
tim1 = tim2

Call Fasp.WN("------99------")
%>